/*
########################################################################
   
    loadd.h - includes and functions for loadd Load Measuring Agent
 
Copyright 2000 Markus Wernig
 
    loadd is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    loadd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with loadd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
########################################################################
*/
#ifndef _LOADD_H
#define _LOADD_H

// includes

#include <unistd.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h> 
#include <sys/un.h>
#include <fcntl.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#include <netdb.h>
#include <syslog.h>

#define _XOPEN_SOURCE

// definitions

typedef unsigned char uchar;

// max buffer size
#define BUF_SIZE 1024
// max numbers of monitored services		
#define MAX_SERVICES 16
// maximum load as defined for checkpoint firewalls
#define CKP_MAXLOAD 230
// standard port
#define PORT 1600

#define CONFIGFILE "/etc/loadd.conf"


bool debug_on =
#ifdef DEBUG
true;
#else
false;
#endif

bool hdebug_on = 
#ifdef HDEBUG
true;
#else
false;
#endif

  

#ifdef LINUX
#define OS "Linux"
typedef socklen_t unint;
#endif

#ifdef SUN
#define OS "SunOS"
typedef int unint;
#endif

#ifdef HPUX
#define OS "HP-UX"
typedef int unint;
#endif

typedef long unsigned int luint;


#define VERSION "version 0.2.5 alpha"


struct sService      {
	char servicename[255];
	long int serv_limit;
	char application[255];
	};

/* FUNCTIONS */


int print_version(char* role) {

printf("\nLoadDaemon %s - %s %s\nmarkus@wernig.net\n\n",role,OS,VERSION);

return(0);

// end of version stuff

}

char* itoa(int intin, char* strout) {

if(!intin){
	char * tempstr="0";
	strcpy(strout,tempstr);
	return(strout);	
}	
if(intin<2^(sizeof(int)*8))
	{
	bool negative = intin<0;	
	int maxnum=10;
	int tempint,movint=abs(intin);
	char tempstr[maxnum+1];
	char * tempptr=NULL;
	tempstr[maxnum]='\0';
	
	int i=0;
	while(i<=maxnum) {
		tempint = (movint % 10);
		movint = movint/10;
		tempstr[maxnum-i-1] = tempint + 48;
		i++;
		}
	i=0;
	while(tempstr[i++] == '0');
	
	
	if(negative)
		{
		tempstr[i-2]='-';
		i--;
		}
	tempptr=&tempstr[i-1];
	strcpy(strout,tempptr);
	return(strout);
	}
else return(0);	
}

#endif
