/*

######################################################################

Program:	loadd
Project:	Load Measuring Daemon for CheckPoint FW1 load balancing
This file:	loadd.cc - Server Code
Other files:	loadd.h - includes and definitions
		
Author:		Markus Wernig
Copyright:	Markus Wernig 2000
		markus@wernig.net
		
Version:	0.1 Mar 2000

-------------------------------------------------------------
		
Description:	the loadd (load daemon) runs standalone or from inetd
		and gathers load information about configured services
		on the machine. from time to time a CKP FW1 may
		connect the UDP port and ask for this data. 
		if it is allowed to, it will get the information.
		
		
-------------------------------------------------------------
		
ToDo:		config file parsing
		authentication
		
		
-------------------------------------------------------------
		
Changes:	Started coding Tue Mar 28 2000

########################################################################
 
Copyright 2000 Markus Wernig
 
    loadd is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    loadd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with loadd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
########################################################################

*/

#include "loadd.h"

/* 	
FUCK! Do I have to use globals?
*/

//  ##############  Socket handles ############## 

int server_sockethandle, client_sockethandle;	

//FUNCTIONS 

//  ############## signal handler for shutdown ############## 

char** ARGV;
char** ENVP;
bool silent;
int ARGC;	

/* Function prototypes */


void bye(int sig);
void reload(int sig);
void usage(char * opt);
int build_reply_packet(uchar * data_in, char commandlines[MAX_SERVICES][BUF_SIZE],sService services[MAX_SERVICES], int num_ser);
int parse_configfile(char* Configfile, char * port, short int * portnum, sService* services, int * num_ser);
int get_next_line(int configfile, char * buffer, int charsize);

// Pointers to signal handler functions

void (*fptr)(int)=bye;    
void (*reloadptr)(int)=reload;

/* #############################################

                      MAIN
   
   #############################################
*/

int main(int argc, char * argv[], char * envp[]) {

//  ############## save command line options ############## 

ARGC = argc;
ARGV = argv;
ENVP = envp;


//  ############## set log options ############## 

openlog("loadd",LOG_PID, LOG_INFO);


//  ############## get command line options ############## 

/*
Allowed options are:
	
	-p [port]: port the server listens on - defaults to 1600
	-s [service]: service to be measured - no default
	-l [number]: allowed number of concurrent connections - no default
	-a [application]: application that must be running
	-h [host]: bind to specific host/address
	-f [file]: configuration file to use. default is /etc/loadd.conf
	-S: run as standalone server
	-q: quiet, no version output
	-v: print version and exit
	-D: enable debugging	


*/
uchar tmp[BUF_SIZE];	// buffer


short int port=PORT;	// defaults to 1600
char * portptr=NULL;
char * hostptr =NULL;
char server_host[BUF_SIZE];

int num_of_services=0;
sService services[MAX_SERVICES];

// initialize service structs
for(int b=0; b<MAX_SERVICES; b++) {
	services[b].servicename[0]=0;
	services[b].serv_limit=0;
	services[b].application[0]=0;
}
char * serviceptr=NULL;
char * limitptr=NULL;
char * appptr=NULL;

char configfile[BUF_SIZE];
strcpy(configfile,CONFIGFILE);
char * configfileptr=configfile;

char shellcode[BUF_SIZE];
char shellcode2[100];
strcpy(shellcode, "RET=`netstat | grep ");
strcpy(shellcode2, " | grep -i established | wc -l 2> /dev/null`; exit $RET");

char commandlines[MAX_SERVICES][BUF_SIZE];

bool quiet = false;
bool standalone=false;
bool localhost = true;


if(argc>1) {
	for (int i=1; i<argc; i++) {
	
	if(argv[i][0]=='-') {
		switch(argv[i][1]) 
			{
			
			case('p'): {				// determine listen port
				
				portptr=(argv[i]+2); 		// point to next char in argv[i]
		
				if((*portptr=='\n') || (*portptr == '\0')){ // if there is no more string there
					portptr=(argv[i+1]);		    // point to next argv[]	
					i=i+1; 				   
			
					}
				if(portptr)
					port=(short)atoi(portptr);
				continue;		
				} 				// end port determination
			case('f'): {				// determine config file
				
				configfileptr=(argv[i]+2); 		// point to next char in argv[i]
		
				if((*configfileptr=='\n') || (*configfileptr == '\0')){ // if there is no more string there
					configfileptr=(argv[i+1]);		    // point to next argv[]	
					i=i+1; 				    
			
					}
				if(configfileptr)
					strncpy(configfile,configfileptr, BUF_SIZE);
				continue;		
				} 
			case('s'): {				// determine one service
				
				serviceptr=(argv[i]+2); 		// point to next char in argv[i]
		
				if((*serviceptr=='\n') || (*serviceptr == '\0')){ // if there is no more string there
					serviceptr=(argv[i+1]);		    // point to next argv[]	
					i=i+1; 				    // 
			
					}
				if(serviceptr) {
					num_of_services=1;
				
				
				strncpy(services[0].servicename,serviceptr, 255);
				
				if(hdebug_on) {
						syslog(LOG_DEBUG,"Service %s, %i services total",services[0].servicename,num_of_services);
					}
				}
				continue;		
				} 
			case('l'): {				// determine one service
				
				limitptr=(argv[i]+2); 		// point to next char in argv[i]
		
				if((*limitptr=='\n') || (*limitptr == '\0')){ // if there is no more string there
					limitptr=(argv[i+1]);		    // point to next argv[]	
					i=i+1; 				    // 
			
					}
				if(limitptr) {
					services[0].serv_limit=atoi(limitptr);
					if(hdebug_on) {
						syslog(LOG_DEBUG,"Service limited to %s",limitptr);
					}
				}
				continue;		
				} 
			case('a'): {				// determine one service
				
				appptr=(argv[i]+2); 		// point to next char in argv[i]
		
				if((*appptr=='\n') || (*appptr == '\0')){ // if there is no more string there
					appptr=(argv[i+1]);		// point to next argv[]
					i=i+1; 				    // 
			
					}
				if(appptr) {
					num_of_services=1;
				
				
				strncpy(services[0].application,appptr, 255);
				
				if(hdebug_on) {
						syslog(LOG_DEBUG,"Application %s, %i services total",services[0].application,num_of_services);
					}
				}
				continue;		
				} 
			case('h'): {				// determine one service
				
				hostptr=(argv[i]+2); 		// point to next char in argv[i]
		
				if((*hostptr=='\n') || (*hostptr == '\0')){ // if there is no more string there
					hostptr=(argv[i+1]);		// point to next argv[]
					i=i+1; 				    // 
			
					}
				if(hostptr) {
					localhost=false;
					strncpy(server_host, hostptr, BUF_SIZE);
					
					if(hdebug_on) 
						syslog(LOG_DEBUG,"Host %s",server_host);
					
				}
				continue;		
				} 
			case('S'): {
				standalone = true;
				if(hdebug_on) {
					syslog(LOG_DEBUG,"Running standalone");
				}
				continue;
				}				
			case('q'): {
				quiet = true;
				continue;
				}
			case('v'): {
				print_version("Server");
				return(0);
				}
			case('D'): {
				debug_on=true;
				if(!strncmp("DDD",&argv[i][1],4)) {
					hdebug_on=true;
				}
				continue;
				}
				
			default: {
				usage(&argv[i][1]);;
				return(1);			
				}
			} // end of switch
		} // end of option determination
	} // end of option (-*) searching
} // end of argument searching

if((serviceptr && !limitptr) || (!serviceptr && limitptr)) {
	usage("No service:limit pair");
}
if(appptr && (!serviceptr || !limitptr)) {
	usage("No service associated with application");
}


//  ############## display version if available ############## 

silent=quiet;
if(!quiet && standalone)
	print_version("Server");
	
	
/* VARIABLES */

	// Network socket stuff

	unint server_len, client_len;		// unsigned for linux, signed for sun solaris, see loadd.h

	int res;
	struct sockaddr_in server_address;	// Network Socket address
	struct sockaddr_in client_address;
	
	
	int src, in;
	
	char clnstr[BUF_SIZE];
	
	
	char myhostname[BUF_SIZE];
	
	// Set signal handler for signals
	
	signal(1, reloadptr);
	signal(2, fptr);	
	signal(3, fptr);
	signal(4, fptr);
	signal(5, fptr);
	signal(6, fptr);	
	signal(7, fptr);
	signal(8, fptr);	
	signal(9, fptr);
	signal(10, fptr);	
	signal(11, fptr);
	signal(12, fptr);
	signal(13, fptr);
	signal(14, fptr);	
	signal(15, fptr);
	
	signal(SIGCHLD, SIG_IGN);		//ignore child exit
	

/* ######################## Get config from file ######################## */


/* Parse configuration file */

int conf = parse_configfile(configfile, portptr, &port, services, &num_of_services);

if(conf<0) {
	if(!num_of_services) {
	syslog(LOG_ERR,"No services defined.");
	return(1);
	}
	

}

if(num_of_services) {

	for(int i=0; i<num_of_services;i++) {
		strcpy(commandlines[i],shellcode);
		strncat(commandlines[i],services[i].servicename,255);
		strncat(commandlines[i],shellcode2,255);
		if(hdebug_on)
			syslog(LOG_DEBUG,"Shell command: %s", commandlines[i]);
	
	}

}
else {
	syslog(LOG_ERR,"No services defined");
	return(1);
	}


/* NETWORK SOCKET DEFINITIONS */
	
	// create the network socket
	server_sockethandle = socket(AF_INET, SOCK_DGRAM, 0); 
	
	// set address family
	server_address.sin_family = AF_INET;
	
	// set address ip addr			
	server_address.sin_addr.s_addr = htonl(INADDR_ANY);
	
	// set address port	
	server_address.sin_port = htons(port);				
	
	server_len = sizeof(server_address);
	client_len = sizeof(client_address);
	
/* NETWORK INFORMATIONS */
	
	/* What's the local system's name? */
	int addr_came_in =0;
	struct in_addr ad;
	struct hostent* host_in;
	char server_addr_in[BUF_SIZE];
	if(hostptr) {			// command line option given?
		
		
		if(inet_aton(server_host, &ad))	{	// if option was an ip addr ... 
			addr_came_in =1;
			strcpy(server_addr_in,server_host);
			if(struct hostent* host_in=gethostbyaddr((const char *)&ad,4,AF_INET)) {	// ... get canonical name ... 
				
				strcpy(server_host,host_in->h_name);	// ... and set server name
				}
			}
	}
	
	if(hdebug_on) 
		syslog(LOG_DEBUG,"Host %s",server_host);
		
	
		
	res=gethostname(myhostname,BUF_SIZE);
	if(hostptr && !localhost) {
		strcpy(myhostname,server_host);
		if(!gethostbyname(myhostname))
			res=-1;
	}
	if(hdebug_on)
		syslog(LOG_DEBUG,"Loaded Server_host %s", myhostname);
	/* trying to get address out of name */
	
	if(res>=0) {
		char *hostaddr, *rawhostaddr;
		struct hostent* host=gethostbyname(myhostname);
	
		rawhostaddr=host->h_addr_list[0];
		hostaddr=inet_ntoa(*(struct in_addr*)rawhostaddr);
	
		if(addr_came_in)
			hostaddr=server_addr_in;
		
	/* end of this try */
 	
		if(!localhost)
			server_address.sin_addr.s_addr = inet_addr(hostaddr);// set address ip addr
			
		if(standalone && !quiet) {
			printf("Setting up server on %s (%s), Port %i\n",myhostname,hostaddr,port);
		}
	}
	else {
	
	
		server_address.sin_addr.s_addr = inet_addr("127.0.0.1");// set address ip addr	
		printf("Setting up server on loopback address (127.0.0.1)\n");
	}
	
	
/* SET SOCKETS TO WORK */

	/* Bind the socket to a specific port */
	
	/* Network Socket */
	
	bind(server_sockethandle, (struct sockaddr *)&server_address, server_len);
	
	/* Prepare for connection requests */
	
	/* Network Socket */
	
	listen(server_sockethandle, 5);
	
	if(standalone && debug_on)
		syslog(LOG_INFO,"LoadDaemon Server ready and waiting on port %i\n",ntohs(server_address.sin_port));
	
	
/* START WORK */

if(standalone && (fork()==0)) {		// fork if we run as standalone server - as son, so we can 
					// disattach from the calling terminal
	
/* STANDALONE SERVER */	

	do {	// init server loop
	
		/* Wait for client connect()ing to our socket; blocking 
		   accept() returns whenever a connection is requested */
		   
		if(debug_on)
			syslog(LOG_INFO,"Standalone Server waiting");
				
		int frombytes = recvfrom(server_sockethandle, (char *)tmp, BUF_SIZE, 0, (struct sockaddr *)&client_address, &client_len);	
		
		
		
		char *clntaddr=inet_ntoa(*(struct in_addr*)&(client_address.sin_addr));
			
		if(debug_on)
			syslog(LOG_INFO,"Client %s requested connection\n", clntaddr);
		
		// collect load data	
		if((res=build_reply_packet(tmp,commandlines,services,num_of_services))>0) {
		
		// handle the request
		int result = sendto(server_sockethandle, (char *)tmp, frombytes, 0, (struct sockaddr*)&client_address, client_len); 	// connect
			
		if(debug_on)
			syslog(LOG_INFO,"Sent packet to %s\n", clntaddr);
		}
			
	} while(1);	// end of server loop
	
}
	
	
else if(!standalone){			// the father handles one-time inetd connections
	
/* INETD SERVER */
	
		
		if(debug_on)   
			syslog(LOG_INFO,"INETD Server waiting");
	
		/* Wait for client connect()ing to our socket; blocking 
		   accept() returns whenever a connection is requested */

		// inetd sets stdin/stout/stderr to be the socket handle
		// get request from stdin
		
		int frombytes = recvfrom(0, (char *)tmp, BUF_SIZE, 0, (struct sockaddr *)&client_address, &client_len);	
		char *clntaddr=inet_ntoa(*(struct in_addr*)&(client_address.sin_addr));
		if(debug_on)
			syslog(LOG_INFO,"Client %s requested connection\n", clntaddr);
	
		
		// handle the one-time request, calculate system load
		
		if((res=build_reply_packet(tmp,commandlines,services,num_of_services))>0) {
		
		// inetd sets stdin/stout/stderr to be the socket handle
		// send reply to stdout
		
		int result = sendto(1, (char *)tmp, frombytes, 0, (struct sockaddr*)&client_address, client_len); 	// connect
		
		if(debug_on)
			syslog(LOG_INFO,"Sent packet to %s\n", clntaddr);
		
		}
		close(client_sockethandle);
			
		return(0); // work is done
		
		
		
	
	} /* INETD SERVER IS DONE */
else return(0);

/* We should never come out there, so exit with error code */	

	
return(777);
}

/* 
########################################################################################

Functions used by loadd

########################################################################################

*/
/* Function usage prints options and exits program in case of illegal command
line values or config options */

void usage(char * opt) {
	printf("\nUnsupported option %s\n\n", opt);
	printf("Allowed options are:\n\n");
	printf("\t-p [port]: port the server listens on - defaults to 1600\n");
	printf("\t-h [host]: bind to specific hostname - default is not to bind\n");
	printf("\t-s [service]: service to be measured - no default\n");
	printf("\t-l [number]: allowed number of concurrent connections - no default\n");
	printf("\t-a [application]: checks for application that must be running\n");
	printf("\t-f [file]: configuration file to use - default is /etc/loadd.conf\n");
	printf("\t-S: run as standalone server\n");
	printf("\t-q: quiet, no version output\n");
	printf("\t-v: print version and exit\n");
	printf("\t-D: enable light debugging\n\n");
	exit(1);
}


/* Function build_packet assembles the reply packet from the precollected data
*/


int build_reply_packet(uchar * data_in, char commandlines[MAX_SERVICES][BUF_SIZE],sService services[MAX_SERVICES], int num_ser) {

	
	if(hdebug_on)
		syslog(LOG_DEBUG,"Building Reply packet: Pass 1 - building reply type");
	for (int i=3; i>=0; i--) { 
		if(data_in[i]) {	// first 4 bytes must be zero in request
			
			syslog(LOG_ERR,"Request type in request packet not zero! Not replying");
			return(-1);	
		}
	}
	
	memcpy(&data_in[0], &data_in[4], 4);	// request type from request - one for now
	
	if(hdebug_on)
		syslog(LOG_DEBUG,"Pass 2 - calculating load with shell cmd"); 
	
	char procwatch[512];
	#ifdef LINUX
	strcpy(procwatch,"PROCRET=`ps ax | grep -v grep | grep -i ");
	#else
	strcpy(procwatch,"PROCRET=`ps -eaf | grep -v grep | grep -i ");
	#endif
	
	int hload=0;
	double tmpload=0;
	double tt=0;
	for (int x=0; x<num_ser; x++) {
	
		if(debug_on)
			syslog(LOG_DEBUG,"Executing %s",commandlines[x]);
		
		tmpload=(system(commandlines[x])>>8)*1.0; // see ./notes
		
		if(services[x].application[0]) {
			strncat(procwatch, services[x].application, 255);
			strcat(procwatch, " | wc -l 2> /dev/null`; exit $PROCRET");
			int procret=(system(procwatch)>>8);
			if(debug_on)
				syslog(LOG_DEBUG,"Evaluating %s: %i",procwatch,procret);
			
			if(!procret) {
				tmpload=services[x].serv_limit;
			}
		}
		tt+=(tmpload/services[x].serv_limit)*CKP_MAXLOAD+0.5;
		
		if(debug_on)
			syslog(LOG_DEBUG,"Load for %s is %f",services[x].servicename, (tmpload/services[x].serv_limit)*CKP_MAXLOAD);
	}
	if(
	debug_on)
		syslog(LOG_DEBUG,"Overall load is %f",tt/num_ser);
		
	if(tt>230*num_ser)
		tt=230*num_ser;
	hload=(int)tt/num_ser;
	
	luint load = htonl(hload); 	// get the load into the variable before calling
	
	memcpy(&data_in[4], &load, 4);	// second 4 bytes are the load [0-230]
	
	if(hdebug_on)
		syslog(LOG_DEBUG,"Pass 3 - completing");
		
	uchar * clnt_msg=&data_in[8];	// rest is the string sent by the client;
					// it is echoed back as it is
	
	if (hdebug_on)
		syslog(LOG_DEBUG,"Message string from client is: %s", clnt_msg);
		
	if (hdebug_on)
		syslog(LOG_DEBUG,"Packet Length: %i", strlen((char*)&data_in[8]+8));
	
	return (1);


}



/*###################################################################################################*/


/* Function parse_configfile() reads data from the configfile, initializes
the appropriate values and returns a status int:
	1	success
	
	-1	no file found or bad syntax
all options are overridden by command line options
*/

/*###################################################################################################*/


int parse_configfile(char* Configfile, char * port, short int * portnum, sService* services, int * num_ser) {
	
	int configfile=open(Configfile, O_RDONLY);
	if(configfile<0) {
                if(debug_on)
                        syslog(LOG_ERR,"Could not open configuration file. Using command line options");
                return(-1);
        }  
	if(debug_on)
		syslog(LOG_DEBUG,"Starting to parse configuration file");
	char temp[BUF_SIZE];
	int res = 1;
	
	int retval=-1;
	int charsize=sizeof(char);
	int j,k=0;
	int servicenumber=0; 
	int z=0;
	while(res) {
		
		res=get_next_line(configfile, temp, charsize);
		if(hdebug_on)
			syslog(LOG_DEBUG,"Called get_next_line; result was %i %s", res, temp);
		
		if(!*num_ser && res && temp[0]) {	// we're parsing the service section
				
			if(hdebug_on)
				syslog(LOG_DEBUG,"Processing data from get_next_line: %s", temp);
			
			
			/* ################ Which application to watch #################### */
				
			if(!strncmp(temp,"application",11)) {
				if(hdebug_on)
					syslog(LOG_DEBUG,"Evaluating application to monitor");
				char application[255]={0};
				int c=0;
				while(temp[c]!=':' && temp[c]!=' ') {
					c++;
				}
				if(hdebug_on)
					syslog(LOG_DEBUG,"Stripped leading blanks: %s", &temp[c]);
				if(temp[++c]) {
					while(temp[c] && temp[c]==' ')
						c++;
					strncpy(application,&temp[c],strlen(&temp[c]));
					if(hdebug_on)
						syslog(LOG_DEBUG,"Loaded application %s, length %i from file", application, strlen(&temp[c]));
					while(application[strlen(application)-1] == ' ')
						application[strlen(application)-1] = 0;	
					strcpy(services[z-1].application,application);
					if(hdebug_on)
						syslog(LOG_DEBUG,"Watching application %s", services[z-1].application);
					continue;
				}
				else {
					syslog(LOG_ERR,"Invalid configuration file format. Using command line options");
                			close(configfile);
					return(-1);
				}
			
			}
			
			/* ################ Which port to listen to #################### */
			
			else if (!strncmp(temp,"port",4)) {
				if(port)	// configfile overridden by command line options
					continue;
				if(hdebug_on)
					syslog(LOG_DEBUG,"Evaluating port number");
				char port_in[255]={0};
				int c=0;
				while(temp[c]!=':' && temp[c]!=' ') {
					c++;
				}
				if(hdebug_on)
					syslog(LOG_DEBUG,"Stripped leading blanks: %s", &temp[c]);
				if(temp[++c]) {
					while(temp[c] && (temp[c]==' ' || temp[c]==':'))
						c++;
					strncpy(port_in,&temp[c],strlen(&temp[c]));
					
					while(port_in[strlen(port_in)-1] == ' ')
						port_in[strlen(port_in)-1] = 0;	
					if(port_in[0] && atoi(port_in)) {
						*portnum=atoi(port_in);	
						if(hdebug_on)
							syslog(LOG_DEBUG,"Got port %i from file", *portnum);
						continue;
					}
					else {
						syslog(LOG_ERR,"Invalid configuration file format. Using command line options");
                				close(configfile);
						return(-1);
					}
				}
			
			
			}
			
			
			/* ################ Which services to monitor #################### */
			
			char service[255]={0};
			char * serptr, * limitptr;
			serptr=service;
			char limit[MAX_SERVICES]={0};
			limitptr=limit;		
			int x=0;
			while(temp[x] && temp[x] != ':')
				x++;
			if(temp[x])
				memcpy(service, temp, x);
			else {
				syslog(LOG_ERR,"Invalid configuration file format. Using command line options");
                		close(configfile);
				return(-1);
			}
		
			if(hdebug_on)
				syslog(LOG_DEBUG,"Loaded service %s from file", service);
		
			/* strip heading and trailing blanks */
			int bla=0;
			while(service[bla++]==' ')
				serptr++;	
			while(service[strlen(service)-1]==' ')
				service[strlen(service)-1]=0;	
					
			if(temp[x+1]) {
				strncpy(limit,&temp[x+1],16);
				bla=0;
				while(limit[bla++]==' ')
					limitptr++;
				while(limit[strlen(limit)-1]==' ')
					limit[strlen(limit)-1]=0;
			}
			else {
				syslog(LOG_ERR,"Invalid configuration file format. Using command line options");
                		close(configfile);
				return(-1);
			}
			if(!limit[0]) {
				syslog(LOG_ERR,"Invalid configuration file format. Using command line options");
                		close(configfile);
				return(-1);
			}
			if(hdebug_on)
				syslog(LOG_DEBUG,"Loaded limit %s from file", limit);
		
			
			if(hdebug_on)
				syslog(LOG_DEBUG,"Stripped blanks");
						
			// TODO: enter values into external structure
			strcpy(services[z].servicename,serptr);
			if(hdebug_on)
				syslog(LOG_DEBUG,"Stored service %s", services[z].servicename);
			services[z++].serv_limit=atoi(limitptr);
			if(hdebug_on)
				syslog(LOG_DEBUG,"Stored limit %i", services[z-1].serv_limit);
			
			servicenumber++;
			
			if(hdebug_on && z) {
				syslog(LOG_DEBUG,"Service: %s - Limit: %i", services[z-1].servicename, services[z-1].serv_limit);
				
			}
			retval=1;
		}							
	} // end of while(res)
close(configfile);
if(!*num_ser)
	*num_ser=servicenumber;	
return(retval);	  
}



/* Function get_next_line fills next line of file into buffer, hopefully stripping 
	commented and empty lines */

int get_next_line(int configfile, char * buffer, int charsize) {
	
	static int lines=0;
	
	int i=0;
	int res=1;
	bool valid=false;
	while(!valid && res) {
	buffer[0]=0;
	lines++;
	if(hdebug_on)
		syslog(LOG_DEBUG,"Parsing line %i", lines);
	
	for (i=0; i<BUF_SIZE; i++) {
               	res=read(configfile, &buffer[i], charsize);
		
                if(!res)        // EOF!
			{
			if(hdebug_on)
				syslog(LOG_DEBUG,"No input left");
                	break;
		}
		if(buffer[0]=='#') {
			if(hdebug_on)
				syslog(LOG_DEBUG,"Comment");
			valid=false;
			buffer[0]=0;
			char dum='a';
			while(dum!='\n' && dum!='\r')
				read(configfile, &dum, charsize);
			break;
		}
              	if(buffer[i]=='#' || buffer[i]=='\n' || buffer[i]=='\r' || buffer[i]==EOF || !buffer[i]) {
                        buffer[i]='\0';
			if(hdebug_on)
				syslog(LOG_DEBUG,"Found valid entry %s",buffer);
                        break;
              	}  
	} // end of for(...) - getting line from file
	if(!res)
		break;
	if(!buffer[0]) {
		valid=false;
		continue;
	}
	
	int j=0;
	
	
	while((buffer[j]=='#' || buffer[j]==' ') && j<strlen(buffer))
		j++;
	if(j>=i) {
		valid=false;
		if(hdebug_on)
			syslog(LOG_DEBUG,"Line %i seems empty", lines);  
	}
	else valid=true;
	} // end of while(!valid)
if(hdebug_on)
	syslog(LOG_DEBUG,"Returning %i %s",strlen(buffer), buffer);
return(strlen(buffer));
}


/* Signal handers */

void  bye(int sig){
		
		if(sig>3 || sig==2) {
			close(server_sockethandle);
			close(client_sockethandle);
			if(debug_on)
				syslog(LOG_INFO,"Reluctantly closing all connections on signal %i\n",sig);
		}	
		exit(0);
	}
	
void reload(int sig) {
	if(sig==1) {
		close(server_sockethandle);
		close(client_sockethandle);
		
		syslog(LOG_INFO,"Reloading configuration");
		if(!silent) {
			ARGV[ARGC++]="-q";
			ARGV[ARGC]=NULL;
			if(hdebug_on)
				syslog(LOG_DEBUG,"Restarting with -q");
		}
		execve(ARGV[0], ARGV, ENVP);
	}
}
