/*
########################################################################

    loadc - client to loadd Load Measuring Agent
 
Copyright 2000 Markus Wernig
 
    loadd is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    loadd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with loadd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
########################################################################
*/





#include "loadd.h"

 

int main(int argc, char* argv[], char* envp[]) {



// set log options

openlog("updnc",LOG_PID, LOG_USER);

// get port number to connect to

int localhost=1;

short int port;
char * hostptr=NULL;
char* portptr=NULL;

bool quiet = true;

if(argc>1) {
	for (int i=1; i<argc; i++) {
	
	if(argv[i][0]=='-') {
		switch(argv[i][1]) 
			{
			
			case('p'): {
				
				portptr=(argv[i]+2); 		// point to next char in argv[i]
		
				if((*portptr=='\n') || (*portptr == '\0')){ // if there is no more string there
					portptr=(argv[i+1]);		    // point to next argv[]	
					i=i+2; 				    // 
			
					}
				if(portptr)
					port=(short)atoi(portptr);
				continue;		
				} // end port determination
			case('q'): {	// print version and stuff on start?
				quiet = false;
				continue;
				}
			case('v'): {	// print version on start and exit?
				print_version("Network Client");
				return(0);
				}
			default: {
				printf("Unsupported option %s\n", &argv[i][1]);
				exit(1);			
				}
			} // end of switch
		} // end of option determination
		else { 	
			if(argv[i]) {
				hostptr=argv[i];
				localhost=0;
			}
		}
	} // end of option (-*) parsing
} // end of argument parsing
/*else {
	printf("Usage: loadc [-options] host\n");
	exit(1);
	}
*/
//  ############## display version if available ############## 

if(!quiet)
	print_version("Network Client");
	


// VARIABLES
	
	uchar tmp[BUF_SIZE];
	strcpy((char *)tmp,"Hello LoadDaemon Server\n");
	char myhostname[BUF_SIZE];
	char *targethostname;
	int dest, out;
		 
	int sockethandle;
	unint len;			// unsigned for linux, signed for sun solaris, see upd.h
	int result, res;

	struct sockaddr_in address;	// Socket address
	
	uchar resultstr[BUF_SIZE];			// receive buffer
	
	uchar sendstr[BUF_SIZE];				// send buffer
	luint zero = htonl(0);
	luint req_type=htonl(1);
	memcpy(&sendstr[0], &zero, 4);
	memcpy(&sendstr[4], &req_type, 4);
	memcpy(&sendstr[8], tmp, (strlen((char *)tmp)+1));
		
	
	/* Who do we connect to? */
	
	if(localhost) {
		targethostname=myhostname;
		}
	else	targethostname=hostptr;
	
	/* trying to get remote address out of name */
	
	char *targethostaddr, *rawtargethostaddr;
	struct hostent* targethost=gethostbyname(targethostname);
	if(!targethost) {
		printf("Could not resolve %s\nExiting\n", targethostname);
		exit(1);
	}
	
	rawtargethostaddr=targethost->h_addr_list[0];
	targethostaddr=inet_ntoa(*(struct in_addr*)rawtargethostaddr);
	
	/* end of this try */
		
/* SOCKET DEFINITIONS */
	
	/* Parameters */
	
	address.sin_family =  AF_INET;			// set address family	
	address.sin_addr.s_addr  = inet_addr(targethostaddr);// set address type to ip addr	

	/* Data socket specific parameters */
	
	if(portptr)
		address.sin_port = htons(port);			// set address port
	else	address.sin_port = htons(PORT);	
	len=sizeof(address);
	
	
/* DATA CONNECTION */

	sockethandle = socket(AF_INET, SOCK_DGRAM, 0); 	// create the socket
	
	result = sendto(sockethandle, sendstr, BUF_SIZE, 0, (struct sockaddr *)&address, len); 	// connect
	
	if(result == -1) {
		printf("Connection Error\n");
		close(sockethandle);
		exit(1);
	}
	else {
		printf("Connected to %s (%s) on port %i\n",targethostname,targethostaddr,ntohs(address.sin_port));	
		
		result = recvfrom(sockethandle, resultstr, BUF_SIZE, 0, (struct	sockaddr *)&address, &len);	
		
		if(result>0) {
			char *srvaddr=inet_ntoa(*(struct in_addr*)&(address.sin_addr));
			luint type, load =0;
			
			memcpy(&type, &resultstr[0], 4);
			memcpy(&load, &resultstr[4], 4);
			printf("Received reply from %s... hooray\n", srvaddr);
			printf("Reply is: Type:%i; Load: %i; String: %s", ntohl(type), ntohl(load), &resultstr[8]);
		}
		else
			printf("No reply\n");
		
		
		close(sockethandle);
		exit(0);
	}
}
