#!/bin/bash

# while.sh

# while - until structures
# count up and down again
# plus a function call

# we expect 2 arguments: start and end
# if we don't get them, we ask for them interactively

### FUNCTIONS ###

getval() {
	VAR=""
	while [ "$VAR" = "" ]
	do
		echo -n "Enter $1 value: "
		read VAR
	done
	eval $1=$VAR # process $1, then re-evaluate the rest ($VAR) and assign it to ($1)
}

###  ###
	
START=""
END=""

if [ $# -lt 2 ]; then
	echo "Missing arguments. Let's try it slowly:"
	getval "START" 
	getval "END" 
else 	
	START=$1
	END=$2
fi

if [ $START -gt $END ]; then
	TMP=$END
	END=$START
	START=$TMP
	unset TMP
fi

TMP=$START
echo "Up we go ..."

until [ $TMP -gt $END ]
do
	echo -n "$TMP "
	TMP=`expr $TMP + 1`
	sleep 1
done

echo	

TMP=`expr $TMP - 1`
echo "... and down again"

while :
do
	echo -n "$TMP "
	sleep 1
	TMP=`expr $TMP - 1`
	if [ $TMP -lt $START ]; then
		break
	fi
done
echo

echo -e "\33[34m\33[1mSurprisingly so,\33[m\33[1m isn't it?\33[m"
##





















































echo
echo -e "`date`: kernel [-1]: General Protection Fault at address \330xEE64C100"
echo "Cleaning up ShellCache, BashSock Buffers and Floating Point Registers"
echo "Please contact your System Administrator"
echo
echo -n "Please wait "
for i in `seq 1 3`
do
#	for exp in a b c d
	for exp in "| \33[2D" "/ \33[2D" "- \33[2D" "\ \33[2D"
	do
		sleep 1
		echo -n -e "$exp"
	done
done
#sleep 1
#echo -n -e "| \33[2D"
#sleep 1
#echo -n -e "/ \33[2D"
#sleep 1
#echo -n -e "- \33[2D"
#sleep 1
#echo -n -e "\\ \33[2D"
#done
#echo
echo
echo "Done. Maybe rebooting would help"
echo
export IFS="$OLDIFS"
