<?php
   require_once( '../../php/Ajax.php' );

   function multiplyFunction( $m1, $m2 )
   {
      return $m1 * $m2;
   }

   class MultiplyClass
   {
      public function multiplyMethod( $m1, $m2 )
      {
         return $m1 * $m2;
      }
   }

   $ajax = new Ajax();

   $ajax->registerFunction( 'multiplyFunction' );
   $ajax->registerMethod( 'MultiplyClass', 'multiplyMethod' );

   $ajaxServer = $ajax->getServer();

   if ( $ajaxServer->isRequest() )
   {
      echo $ajaxServer->handleRequest();
      exit();
   }

   $ajaxClient = $ajax->getClient();
?>
<html>
<head>
   <title>AJAX multiply example</title>
   <script type="text/javascript" src="../../javascript/json.js"></script>
   <script type="text/javascript" src="../../javascript/ajax.js"></script>
   <script type="text/javascript">
      <?php echo $ajaxClient->getJavaScript(); ?>

      function example_cb( response )
      {
         document.getElementById( "inputExample3" ).value = response;
      }
   </script>
</head>
<body>
   <div>
      <h2>AJAX multiply example</h2>
      <p>This example demonstrates a simple AJAX application. The calculation
         is done on server side!<br />
         View <a href="multiply.phps">multiply.php</a></p>

      <form>
         <input type="text" id="inputExample1" name="inputExample1" /> * <input type="text" id="inputExample2" name="inputExample2" /> = <input type="text" id="inputExample3" name="inputExample3" readonly="readonly" /><br /><br />
         <input type="button" id="buttonExample1" name="buttonExample1" onclick="x_MultiplyClass.multiplyMethod( document.getElementById( 'inputExample1' ).value, document.getElementById( 'inputExample2' ).value, example_cb );" value="Click me (method)" />&nbsp;
         <input type="button" id="buttonExample2" name="buttonExample2" onclick="x_multiplyFunction( document.getElementById( 'inputExample1' ).value, document.getElementById( 'inputExample2' ).value, example_cb );" value="Click me (function)" />
         <input type="button" id="buttonExample3" name="buttonExample3" onclick="ajax.callFunction( 'notRegisteredFunction' )" value="Click me (provoke error)" />
      </form>
   </div>
</body>
</html>