<?php
require_once('inc/config.inc.php');
require_once('lib/News.class.php');
require_once('../../php/Ajax.php' );

class NewsHandler {
	private $News;

	public function __construct() {
		$this->News = new News();
	} 
  
	public function showAllNews() {
		$news = $this->News->getAllNews();
		if (empty($news)) {
			return date(DATE_RFC822).": No news available";
		}

		$newshtml = date(DATE_RFC822).': <br />';
		foreach ($news as $key => $value) {
			$newshtml .= '- <a href="#" onclick="x_showNewsItem(\''.$value['news_id'].'\',toAlert)">'.$value['news_title'].'</a><br/>';
		}
		return $newshtml;
  }

	public function addNewsItem($title = "") {
		$data['news_title'] = $title;
		$this->News->insertNews($data);
		return "added!";
	}

	public function showNewsItem($id = "") {
		$newsitem = $this->News->getNews($id);
		return "ID:".$newsitem['news_id']."\nTitle: ".$newsitem['news_title'];
	}
}

function showNewsItem($id = "") {
	$NewsHandler = new NewsHandler();
	return "Time is now: ".date(DATE_RFC822)."\n".$NewsHandler->showNewsItem($id);

}

function addNewsItem($title = "") {
	$NewsHandler = new NewsHandler();
	return $NewsHandler->addNewsItem($title);
}

try {
	$ajax = new Ajax();

	// couldn't we use more then one methods?
 	// sure we can! but submitted a patch:
	// http://sourceforge.net/tracker/index.php?func=detail&aid=1679051&group_id=142769&atid=753559

	// doing it with functions, then
	$ajax->registerFunction('showNewsItem');
	$ajax->registerFunction('addNewsItem');
		
	$ajax->registerMethod('NewsHandler', 'showAllNews');
	$ajax->registerMethod('NewsHandler', 'addNewsItem');

	$ajaxServer = $ajax->getServer();
	$ajaxClient = $ajax->getClient();

	if ($ajaxServer->isRequest()) {
		echo $ajaxServer->handleRequest();
		exit;
	}
} catch(Exception $e) {
	echo $e->getMessage() . "\n\n";
	exit;
}
/*
//for testing...
$h = new NewsHandler();
echo $h->showAllNews();
echo $h->showNewsItem(6);
echo $h->addNewsItem("testing");
*/
?>
<html>
<head>
   <title>Database example</title>
   <script type="text/javascript" src="../../javascript/json.js"></script>
   <script type="text/javascript" src="../../javascript/ajax.js"></script>
   <script type="text/javascript">
   <?php echo $ajaxClient->getJavaScript(); ?>

      function toNews(response) {
				x = document.getElementById("news");
				x.innerHTML = '';
				x.innerHTML = response;
      }

			function toAlert(response) {
				alert(response);
			}
   </script>
<script language="JavaScript">
<!--

function doLoad()
{
    // the timeout value should be the same as in the "refresh" meta-tag
    setTimeout( "refresh()", 10*1000 );
}

function refresh()
{
    //  This version of the refresh function will cause a new
    //  entry in the visitor's history.  It is provided for
    //  those browsers that only support JavaScript 1.0.
    //
		if (document.newsform.autoreload.checked == true) {
	    x_NewsHandler.showAllNews(toNews);
		}
		doLoad();
}
//-->
</script>
</head>
<body onload="doLoad()">
	<h2>Simple AJAX Database Example</h2>
	<p>Its now: <?php echo date(DATE_RFC822); ?></p>
	<hr /> 
  <form name="newsform">
	Autoreload <input type="checkbox" name="autoreload" value="1">	<input type="button" onclick="x_NewsHandler.showAllNews(toNews)" value="updateNewsManually"/> 
	<hr /> 
	<div id="news">Checking for news...</div>
	<br /><br />
	<hr /> 
	<input type="test" name="newsitem" value=""> <input type="button" onclick="x_NewsHandler.addNewsItem(document.newsform.newsitem.value,toAlert)" value="addNewsItem"/> 
  </form>
<?php
if ($_GET['youtube'] != "") {
 echo '<object width="425" height="350"><param name="movie" value="http://www.youtube.com/v/XLrPKmGmYdo"></param><param name="wmode" value="transparent"></param><embed src="http://www.youtube.com/v/XLrPKmGmYdo" type="application/x-shockwave-flash" wmode="transparent" width="425" height="350"></embed></object>';
}
?>
</body>
</html>
