<?php
   require_once( '../../php/Ajax.php' );

   function autocomplete( $text )
   {
      // Create an array with some suggestions.
      // Theoretically the suggestions could be fetched from a database.
      $suggestions   = array();
      $suggestions[] = 'AJAX';
      $suggestions[] = 'AJASON';
      $suggestions[] = 'PHP';
      $suggestions[] = 'JavaScript';
      $suggestions[] = 'Sven Jacobs';
           
      // Find first suggestion
      foreach( $suggestions as &$s )
      {
         if ( substr( $s, 0, strlen( $text ) ) == $text )
         {
            return substr( $s, strlen( $text ) );
         }
      }
      
      return null;
   }

   $ajax = new Ajax();

   $ajax->registerFunction( 'autocomplete' );
   
   $ajaxServer = $ajax->getServer();

   if ( $ajaxServer->isRequest() )
   {
      echo $ajaxServer->handleRequest();
      exit();
   }

   $ajaxClient = $ajax->getClient();
?>
<html>
<head>
   <title>AJAX autocompletion example</title>
   <script type="text/javascript" src="../../javascript/json.js"></script>
   <script type="text/javascript" src="../../javascript/ajax.js"></script>
   <script type="text/javascript">
      <?php echo $ajaxClient->getJavaScript(); ?>

      function autocomplete_precheck( sender, e )
      {
         // Check for alpha numeric keys
         if ( ( e.keyCode >= 48 && e.keyCode <= 57 ) || ( e.keyCode >= 65 && e.keyCode <= 90 ) )
         {
            x_autocomplete( sender.value, autocomplete_cb );
         }
      }
      
      function autocomplete_cb( suggestion )
      {     
         if ( suggestion )
         {
            var inp = document.getElementById( 'inputAC' );         
                
            // IE
            if ( document.selection )
            {
               var sel = document.selection.createRange();
               sel.text = suggestion;            
               sel.move( 'character', -suggestion.length );     
               sel.findText( suggestion );
               sel.select();
            }
            else
            {
               var preLength = inp.value.length;
               inp.value += suggestion;
               inp.selectionStart = preLength;
               inp.selectionEnd   = inp.value.length;            
            }            
         }
      }
   </script>
</head>
<body>
   <div>   
      <h2>AJAX autocompletion example</h2>
      <p>This example demonstrates an autocompletion text field.
         The suggestion is loaded from the server.<br />
         Try to type AJAX or AJASON for example.<br />
         View <a href="autocomplete.phps">autocomplete.php</a>
      </p>

      <form>
         <input type="text" id="inputAC" name="inputAC" onkeyup="autocomplete_precheck( this, event );" />
      </form>
   </div>
</body>
</html>